/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.contracts.controller;

import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import itx.core.web.BaseController;
import itx.core.web.WebRequest;
import itx.erp.base.model.DbFile;
import itx.erp.base.model.User;
import itx.erp.base.model.UserGroup;
import itx.erp.base.model.UserPermission;
import itx.erp.base.service.UserService;
import itx.erp.contracts.model.Contract;
import itx.erp.contracts.service.ContractService;
import itx.erp.contracts.validator.ContractValidator;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import jtbcore.exception.AuthorizationException;
import jtbcore.exception.JTBException;
import jtbcore.util.NumberUtil;

public class ContractEditController
extends BaseController {
    protected ContractService contractService;
    protected UserService userService;

    public ContractService getContractService() {
        return this.contractService;
    }

    public void setContractService(ContractService contractService) {
        this.contractService = contractService;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    @Override
    public void handleRequest(WebRequest webRequest) throws Exception {
        super.executeAction(webRequest);
    }

    public void viewAction(WebRequest req) throws Exception {
        Integer id = req.getParamInt("contractId");
        if (!this.contractService.hasPermission(req.getUserId(), id)) {
            throw new AuthorizationException("No permission to contract");
        }
        Contract c = this.contractService.readContract(id);
        if (!this.userService.isAdmin(req.getUserId())) {
            for (Contract rc : c.getRelatedContracts()) {
                rc.setAllowView(this.contractService.hasPermission(req.getUserId(), rc.getContractId()));
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("contract", c);
        result.put("writable", this.contractService.hasWritePermission(req.getUserId(), id));
        req.renderJson(result);
    }

    public void defaultSettingsAction(WebRequest req) throws SQLException, StreamWriteException, DatabindException, IOException {
        User user = this.userService.readUser(req.getUserId());
        ArrayList<UserPermission> permissions = new ArrayList<UserPermission>();
        UserPermission up_user = new UserPermission();
        up_user.setUserId(req.getUserId());
        up_user.setAccessMethod("write");
        up_user.getBaseStringMap().setProperty("username", user.getUsername());
        permissions.add(up_user);
        for (UserGroup ug : user.getGroup()) {
            UserPermission up_group = new UserPermission();
            up_group.setGroupId(ug.getUserGroupId());
            up_group.setAccessMethod("write");
            up_group.getBaseStringMap().setProperty("group_name", ug.getGroupName());
            permissions.add(up_group);
        }
        HashMap<String, ArrayList<UserPermission>> result = new HashMap<String, ArrayList<UserPermission>>();
        result.put("permissions", permissions);
        req.renderJson(result);
    }

    public void saveAction(WebRequest req) throws Exception {
        Integer contractId = req.getParamInt("contractId");
        if (contractId != null && !this.contractService.hasWritePermission(req.getUserId(), contractId)) {
            throw new AuthorizationException("No permission to contract");
        }
        Contract c = contractId != null ? this.contractService.readContract(contractId) : new Contract();
        c.setStatus(req.getParameter("status"));
        c.setName(req.getParameter("name"));
        c.setAmountDescription(req.getParameter("amountDescription"));
        c.setContractTypeId(req.getParamInt("contractTypeId"));
        c.setCustomerId(req.getParamInt("customerId"));
        c.setStartDate(req.getParamDate("startDate"));
        c.setEndDate(req.getParamDate("endDate"));
        c.setTimeNotice(req.getParamInt("timeNotice"));
        c.setTimeNoticeUnit(req.getParameter("timeNoticeUnit"));
        c.setRenewPeriod(req.getParamInt("renewPeriod"));
        c.setRenewUnit(req.getParameter("renewUnit"));
        c.setAutoRenew(req.getParamBool("autoRenew"));
        c.setNote(req.getParameter("note"));
        int recno = 0;
        for (String key : req.getParameterNames()) {
            UserPermission p;
            if (!key.startsWith("perm_ug_")) continue;
            Integer no = NumberUtil.tryParseInt(key.replace("perm_ug_", ""));
            String refObjectId = req.getParameter("perm_ug_" + String.valueOf(no));
            String access = req.getParameter("perm_access_" + String.valueOf(no));
            if (refObjectId == null || refObjectId.trim().length() == 0) continue;
            if (recno < c.getPermissions().size()) {
                p = c.getPermissions().get(recno);
            } else {
                p = new UserPermission();
                c.getPermissions().add(p);
            }
            p.setUserId(null);
            p.setGroupId(null);
            String[] typeId = refObjectId.split("-", 2);
            if (typeId.length != 2) continue;
            String permType = typeId[0];
            String strObjectId = typeId[1];
            Integer objectId = NumberUtil.tryParseInt(strObjectId);
            if (objectId == null) continue;
            if ("user".equals(permType)) {
                p.setUserId(objectId);
            } else {
                if (!"group".equals(permType)) continue;
                p.setGroupId(objectId);
            }
            p.setAccessMethod(access);
            ++recno;
        }
        if (c.getPermissions().size() > recno) {
            List<UserPermission> ups = c.getPermissions().subList(0, recno);
            c.setPermissions(ups);
        }
        if (c.getContractId() == null && c.getPermissions().size() == 0) {
            UserPermission cp = new UserPermission();
            cp.setUserId(req.getUserId());
            cp.setAccessMethod("write");
            c.addPermission(cp);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        ContractValidator v = new ContractValidator();
        if (v.validate(c)) {
            contractId = this.contractService.saveContract(c, req.getUserId());
            this.contractService.renewContract(c);
            result.put("success", true);
            result.put("contractId", contractId);
        } else {
            result.put("error", true);
            result.put("errors", v.getErrors());
        }
        req.renderJson(result);
    }

    public void deleteAction(WebRequest req) throws Exception {
        Integer contractId = req.getParamInt("contractId");
        if (!this.contractService.hasWritePermission(req.getUserId(), contractId)) {
            throw new AuthorizationException("No permission to contract");
        }
        this.contractService.deleteContract(contractId, req.getUserId());
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("success", true);
        req.renderJson(result);
    }

    public void updateFileSortAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException, AuthorizationException {
        Integer contractId = req.getParamInt("contractId");
        if (!this.contractService.hasWritePermission(req.getUserId(), contractId)) {
            throw new AuthorizationException("No permission to contract");
        }
        List<Integer> dbFileIds = NumberUtil.csl2int(req.getParameter("dbFileIds"));
        this.contractService.updateFileSort(contractId, dbFileIds);
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("success", true);
        req.renderJson(result);
    }

    public void linkFileAction(WebRequest req) throws SQLException, IOException, JTBException {
        Integer contractId = req.getParamInt("contractId");
        Integer dbFileId = req.getParamInt("dbFileId");
        if (!this.contractService.hasWritePermission(req.getUserId(), contractId)) {
            throw new AuthorizationException("No permission to contract");
        }
        this.contractService.linkFile(contractId, dbFileId, req.getUserId());
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("success", true);
        req.renderJson(result);
    }

    public void unlinkFileAction(WebRequest req) throws SQLException, IOException, JTBException {
        Integer contractId = req.getParamInt("contractId");
        Integer dbFileId = req.getParamInt("dbFileId");
        if (!this.contractService.hasWritePermission(req.getUserId(), contractId)) {
            throw new AuthorizationException("No permission to contract");
        }
        this.contractService.unlinkFile(contractId, dbFileId, req.getUserId());
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("success", true);
        req.renderJson(result);
    }

    public void linkRelatedContractAction(WebRequest req) throws SQLException, IOException, JTBException {
        Integer contractId = req.getParamInt("contractId");
        Integer refContractId = req.getParamInt("refContractId");
        if (!this.contractService.hasWritePermission(req.getUserId(), contractId)) {
            throw new AuthorizationException("No permission to contract");
        }
        this.contractService.linkContract(contractId, refContractId, req.getUserId());
        HashMap<String, Boolean> r = new HashMap<String, Boolean>();
        r.put("success", true);
        req.renderJson(r);
    }

    public void unlinkRelatedContractAction(WebRequest req) throws SQLException, IOException, JTBException {
        Integer contractId = req.getParamInt("contractId");
        Integer refContractId = req.getParamInt("refContractId");
        if (!this.contractService.hasWritePermission(req.getUserId(), contractId)) {
            throw new AuthorizationException("No permission to contract");
        }
        this.contractService.unlinkContract(contractId, refContractId, req.getUserId());
        HashMap<String, Boolean> r = new HashMap<String, Boolean>();
        r.put("success", true);
        req.renderJson(r);
    }

    public void listFilesAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        Integer contractId = req.getParamInt("contractId");
        if (!this.contractService.hasPermission(req.getUserId(), contractId)) {
            throw new AuthorizationException("No permission to contract");
        }
        List<DbFile> files = this.contractService.listFiles(contractId);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("files", files);
        result.put("success", true);
        req.renderJson(result);
    }
}

